/*
 * Copyright (C) 2012, Panasonic Corporation 
 */

#if defined(CONFIG_USB_PANASONIC_LD4)

static inline void internal_host_peripheryhw_init( void )
{
  unsigned long mio_reg_base;
  u32 val;

  mio_reg_base = (unsigned long)ioremap(0x59810000, PAGE_SIZE);
  if (!mio_reg_base) {
    printk(KERN_ERR "internal_host_peripheryhw_init: ioremap failed\n");
    return;
  }

  writel(0x00000001, mio_reg_base + 0x0114); /* MIO_USBRSTCTRL0 */
  writel(0x00000001, mio_reg_base + 0x0314); /* MIO_USBRSTCTRL1 */
  writel(0x00000001, mio_reg_base + 0x0514); /* MIO_USBRSTCTRL2 */

  val = readl( mio_reg_base + 0x0030 );
  val = val & ~0x07000000;
  writel( val, mio_reg_base + 0x0030 );

  val = readl( mio_reg_base + 0x0230 );
  val = val & ~0x07000000;
  writel( val, mio_reg_base + 0x0230 );

  val = readl( mio_reg_base + 0x0430 );
  val = val & ~0x07000000;
  writel( val, mio_reg_base + 0x0430 );

  iounmap((void *)mio_reg_base);
}

#define INTERNAL_EHCI_BASE_ADR_0	(0x5A800000)
#define INTERNAL_EHCI_IRQ_NUM_0		(112)
#define INTERNAL_EHCI_BASE_ADR_1	(0x5A810000)
#define INTERNAL_EHCI_IRQ_NUM_1		(113)
#define INTERNAL_EHCI_BASE_ADR_2	(0x5A820000)
#define INTERNAL_EHCI_IRQ_NUM_2		(114)
#define USBH_EHCI_BURSTSIZE         (0x00004080)
#define USBH_EHCI_TXFILLTUNING      (0x00020000)
#define INTERNAL_EHCI_MEM_LEN       (0x200)
#define INTERNAL_EHCI_CAPS_BASE     (0x0100)
#define INTERNAL_EHCI_REGS_BASE     (0x0140)
#define USBH_IOBASEADDR       		(0x0)

static const struct resource host_res[][2] = {
	{
		{
			.start	= INTERNAL_EHCI_BASE_ADR_0,
			.end	= INTERNAL_EHCI_BASE_ADR_0 + INTERNAL_EHCI_MEM_LEN - 1,
			.flags	= IORESOURCE_MEM,
		}, {
			.start	= INTERNAL_EHCI_IRQ_NUM_0,
			.flags	= IORESOURCE_IRQ,
		},
	},
	{
		{
			.start	= INTERNAL_EHCI_BASE_ADR_1,
			.end	= INTERNAL_EHCI_BASE_ADR_1 + INTERNAL_EHCI_MEM_LEN - 1,
			.flags	= IORESOURCE_MEM,
		}, {
			.start	= INTERNAL_EHCI_IRQ_NUM_1,
			.flags	= IORESOURCE_IRQ,
		},
	},
	{
		{
			.start	= INTERNAL_EHCI_BASE_ADR_2,
			.end	= INTERNAL_EHCI_BASE_ADR_2 + INTERNAL_EHCI_MEM_LEN - 1,
			.flags	= IORESOURCE_MEM,
		}, {
			.start	= INTERNAL_EHCI_IRQ_NUM_2,
			.flags	= IORESOURCE_IRQ,
		},
	},
};



#ifdef CONFIG_USB_PANASONIC_HOST_INTRMEM

#define INTERMEM_SIZE	16384
#define INTERMEM_OFFSET	0x4000
typedef struct _INTERMEM_CONFIG{
	int size;
	int num;
} INTERMEM_CONFIG;

static const INTERMEM_CONFIG intermem_configuration[]={

#ifdef CONFIG_USB_PANASONIC_HOST
	{	2048,	1},
#else
	{	1024,	2},
#endif
	{	128,	112},
};
#endif
#endif /* CONFIG_USB_PANASONIC_LD4 */

